/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

public abstract class CharToGlyphMapper {
    public static final int HI_SURROGATE_SHIFT = 10;
    public static final int HI_SURROGATE_START = 55296;
    public static final int HI_SURROGATE_END = 56319;
    public static final int LO_SURROGATE_START = 56320;
    public static final int LO_SURROGATE_END = 57343;
    public static final int SURROGATES_START = 65536;
    public static final int MISSING_GLYPH = 0;
    public static final int INVISIBLE_GLYPH_ID = 65535;
    protected int missingGlyph = 0;

    public boolean canDisplay(char cp) {
        int glyph = this.charToGlyph(cp);
        return glyph != this.missingGlyph;
    }

    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public abstract int getGlyphCode(int var1);

    public int charToGlyph(char unicode) {
        return this.getGlyphCode(unicode);
    }

    public int charToGlyph(int unicode) {
        return this.getGlyphCode(unicode);
    }

    public void charsToGlyphs(int start, int count, char[] unicodes, int[] glyphs, int glyphStart) {
        for (int i = 0; i < count; ++i) {
            char low;
            int code = unicodes[start + i];
            if (code >= 55296 && code <= 56319 && i + 1 < count && (low = unicodes[start + i + 1]) >= '\udc00' && low <= '\udfff') {
                code = (code - 55296 << 10) + low - 56320 + 65536;
                glyphs[glyphStart + i] = this.getGlyphCode(code);
                glyphs[glyphStart + ++i] = 65535;
                continue;
            }
            glyphs[glyphStart + i] = this.getGlyphCode(code);
        }
    }

    public void charsToGlyphs(int start, int count, char[] unicodes, int[] glyphs) {
        this.charsToGlyphs(start, count, unicodes, glyphs, 0);
    }

    public void charsToGlyphs(int count, char[] unicodes, int[] glyphs) {
        this.charsToGlyphs(0, count, unicodes, glyphs, 0);
    }
}

